﻿// minimum and maximum values for frequencies and output levels
var AttenMin = 0;
var AttenMax = 65;
/*
 * these values are used for 2 purposes: determining if a value has changed and
 *  checking if there was an error for a control
 *
 *  0 means that an item wasn"t changed and there were no errors
 *  1 means that an item was changed but there were no errors
 *  2 means that an item was changed and there was an errors
 *
 * when a control recieves focus, these arrays are checked and if there is a
 *  control that has an error, we"ll move the focus there instead
 */
 
var modulation_set   = 0;
var symbol_rate_set  = 0;
var bw_set           = 0;
var interleaving_set = 0;
var mode_set         = 0;
var transport_id_set = 0;
var manager_set      = 0;
var group_name_set   = 0;
var atten_set        = 0;
var dts_adjust_set   = 0;
var sdv_support_set  = 0;
var starting_udp_set = 0;
var interval_set = new Array(0,0,0,0,0,0,0,0);


// page state and annex related flags
var PageLoadFlag = 0;
var g_annex_mode = 0; // variable for holding the annex mode value
var g_annex_text;

// card ,port and channel values for the page being displayed
var card_index;//a
var port_index;//b
var channel_index;//c
var global_channel_index;//a/b.c

var language;
var userName;

var ctrlName = new Array("modulation", "symbol_rate", "bandwidth", "interleaving", "channel_mode", "transport_id", 
						"qam_manager", "qam_group_name", "atten", "dts_adjust", "sdv_support", "starting_udp_port");
var DISP_ATTR_FLAG = 1;
var RAD_WRT_FLAG = 2;

var deviceType;
var TYPE_518B = 2;

function SetColor(obj, color)
{
	obj.style.backgroundColor = color;
}

function ModulationChange(obj)
{
	EnableApply();
	modulation_set = 1;
	SetColor(obj,"Yellow");
}

function BWChange(obj)
{
	EnableApply();
	bw_set = 1;
	SetColor(obj,"Yellow");
}
function interleavingChange(obj)
{
	EnableApply();
	interleaving_set = 1;
	SetColor(obj,"Yellow");
}


function ValidateSymbolRate(obj)
{
	var symbol_rate = parseFloat(obj.value);
	var max_rate;
	
	var patten  = /^\d+(\.\d+)?$/;
	if(!patten.test(symbol_rate))
	{
		if(language == 0)
		{
			alert("Symbol Rate should be a decimal number!");
		}
		else
		{
			alert("符号率值应该为十进制数!");
		}
		return false;
	}

	if(validateFloat(symbol_rate) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Symbol Rate.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的符号率。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if(validateAccuracy(symbol_rate, 3) == false)
	{
		if(language == 0)
		{
			alert("Accuracy for Symbol Rate is 3 digits.");
		}
		else
		{
			alert("符号率的有效性最多到小数点后三位。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if(g_annex_text == "ITU-A")
	{
		max_rate = 7.000;
	}

	if(g_annex_text == "ITU-C")
	{
		max_rate = 5.500;
	}
	if((symbol_rate < 3.500) || (symbol_rate > max_rate))
	{
		if(language == 0)
		{
			alert("Valid range for Symbol Rate is 3.500 - " + max_rate.toFixed(3) + " Mbaud.");
		}
		else
		{
			alert("符号率的有效范围是3.500 - " + max_rate.toFixed(3) + " Mbaud.");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function SymbolRateChange(obj)
{
	var symbol_rate = parseFloat(obj.value);
	
	if(ValidateSymbolRate(obj) == false)
	{
		symbol_rate_set = 2;
		SetColor(obj,"Red");
		return false;
	}
	else
	{
		obj.value = symbol_rate.toFixed(3);
		symbol_rate_set = 1;
		SetColor(obj,"Yellow");
		EnableApply();
		return true;
	}
}

function ModeChange(obj)
{
	EnableApply();
	mode_set = 1;
	SetColor(obj,"Yellow");
}

function ValidateTransportId(obj)
{
	var transport_id = obj.value;

	if(validateNumber(transport_id) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Transport Stream ID.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的传输流ID。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((transport_id < 0) || (transport_id > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Transport Stream ID is 0 - 65535.");
		}
		else
		{
			alert("传输流ID的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function TansportIdChange(obj)
{
	if(ValidateTransportId(obj) == false)
	{
		transport_id_set = 2;
		SetColor(obj,"Red");
		return false;
	}
	else
	{
		transport_id_set = 1;
		SetColor(obj,"Yellow");
		EnableApply();
		return true;
	}
}

function ValidateOrigiNetworkId(obj)
{
	var origi_network_id = obj.value;

	if(validateNumber(origi_network_id) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Original Network ID.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的原始网络ID。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((origi_network_id < 0) || (origi_network_id > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Original Network ID is 0 - 65535.");
		}
		else
		{
			alert("原始网络ID的范围是0-65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function OrigiNetworkIdChange(obj)
{
	if(ValidateOrigiNetworkId(obj) == false)
	{
		origi_network_id_set = 2;
		SetColor(obj,"Red");
		return false;
	}
	else
	{
		origi_network_id_set = 1;
		SetColor(obj,"Yellow");
		EnableApply();
		return true;
	}
}

function ManagerChange(obj)
{
	EnableApply();
	manager_set = 1;
	SetColor(obj,"Yellow");
}

function ValidateGroupName(obj)
{
	var group_name = obj.value;
	if(validateName(group_name, 1, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function GroupNameChange(obj)
{
	if(ValidateGroupName(obj) == false)
	{
		group_name_set = 2;
		SetColor(obj,"Red");
		return false;
	}
	else
	{
		group_name_set = 1;
		SetColor(obj,"Yellow");
		EnableApply();
		return true;
	}
}

function ValidateAtten(obj)
{
	var atten = obj.value;

	if(validateFloat(atten) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Atten.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的衰减值。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if(validateAccuracy(atten, 3) == false)
	{
		if(language == 0)
		{
			alert("Accuracy for Atten is 3 digits.");
		}
		else
		{
			alert("衰减的有效性最多到小数点后三位。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((atten < AttenMin) || (atten > AttenMax))
	{
		if(language == 0)
		{
			alert("Valid range for Atten is " + AttenMin + " - " + AttenMax + ".");
		}
		else
		{
			alert("衰减的有效范围是" + AttenMin + " - " + AttenMax + "。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function AttenChange(obj)
{
	if(ValidateAtten(obj) == false)
	{
		atten_set = 2;
		SetColor(obj,"Red");
		return false;
	}
	else
	{
		SetColor(obj,"Yellow");
		atten_set = 1;
		EnableApply();
		return true;
	}
}

function DtsAdjustChange(obj)
{
	EnableApply();
	dts_adjust_set = 1;
	SetColor(obj,"Yellow");
}

function SdvSupportChange(obj)
{
	EnableApply();
	sdv_support_set = 1;
	SetColor(obj,"Yellow");
}

function validateStartUdp(obj)
{
	var startUdp = obj.value;
	if(validateNumber(startUdp) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Starting UDP Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的动态UDP起始值。");
		}
		return false;
	}
	if((startUdp < 0) || (startUdp > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Starting UDP Port is 0 - 65535.");
		}
		else
		{
			alert("动态UDP起始值的有效范围是0 - 65535。");
		}
		return false;
	}
	return true;
}

function StartUdpPortChange(obj)
{
	if(validateStartUdp(obj) == false)
	{
		starting_udp_set = 2;
		SetColor(obj,"Red");
		return false;
	}
	else
	{
		SetColor(obj,"Yellow");
		starting_udp_set = 1;
		EnableApply();
		return true;
	}
}

function ValidateInterval(obj)
{
	var interval = obj.value;

	if(validateNumber(interval) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Interval.");
		}
		else
		{
			alert("无效的数字，请输入有效的时间间隔。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}

	if((interval < 0) || (interval > 1000))
	{
		if(language == 0)
		{
			alert("Valid range for Interval is 0 - 1000.");
		}
		else
		{
			alert("时间间隔的范围是0 - 1000。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function IntervalChange(obj, num)
{
	if(ValidateInterval(obj) == false)
	{
		interval_set[num] = 2;
		SetColor(obj,"Red");
		return false;
	}
	else
	{
		SetColor(obj,"Yellow");
		interval_set[num] = 1;
		EnableApply();
		return true;
	}
}


// update display based on the annex type
function AnnexDisplay(g_annex_mode)
{
	var symbol_rate_id = document.getElementById("symbol_rate");
	var a_or_c = false;
	var max_symbols;

	switch(g_annex_mode) 
	{
		case 1:
			g_annex_text = "Unknown";
			break;
		case 2:
			g_annex_text = "Other";
			break;
		case 3:
			g_annex_text = "ITU-A";
			a_or_c = true;
			max_symbols = 7.000;
			break;
		case 4:
			g_annex_text = "ITU-B";
			symbol_rate_id.disabled = true;
			break;
		case 5:
			g_annex_text = "ITU-C";
			a_or_c = true;
			max_symbols = 5.500;
			break;
		default:
			break;
	}

	// update annex type display
//	document.getElementById("Encoding_Type").innerHTML = g_annex_text;

	if(a_or_c)
	{
		symbol_rate_id.disabled = false;
		if(language == 0)
		{
			symbol_rate_id.title = "Symbol rate for the QAM channel(" + g_annex_text + ": 3.500-" + max_symbols.toFixed(3) + ")";
		}
		else
		{
			symbol_rate_id.title = "频点的符号率(" + g_annex_text + ": 3.500-" + max_symbols.toFixed(3) + ")";
		}
	}
}

function DisplayChannelParameters(response)
{
	var channel_values = response.split("&");
	var response_index = 0;
	var symbol_rate;

	/*
	 * Here are what the responses are for the port:
	 * response[0]: center frequency
	 * response[1]: modulation
	 * response[2]: symbol rate
	 * response[3]: channel mode
	 * response[4]: transport stream id
	 * response[5]: original network id
	 * response[6]: qam manager
	 * response[7]: qam group name
	 * response[8]: atten
	 * response[9~16]: interval
	 */

	document.getElementById("centre_freq").innerHTML = parseFloat(channel_values[response_index++]).toFixed(3);
	document.getElementById("modulation").value = parseInt(channel_values[response_index++]);
	document.getElementById("symbol_rate").value = parseFloat(channel_values[response_index++]).toFixed(3);
	document.getElementById("bandwidth").value = parseInt(channel_values[response_index++]);
	document.getElementById("interleaving").value = parseInt(channel_values[response_index++]);
	document.getElementById("channel_mode").value = parseInt(channel_values[response_index++]);
	document.getElementById("transport_id").value = parseInt(channel_values[response_index++]);
	document.getElementById("qam_manager").value = parseInt(channel_values[response_index++]);
	document.getElementById("qam_group_name").value = channel_values[response_index++];
	document.getElementById("atten").value = parseFloat(channel_values[response_index++]).toFixed(3);
	document.getElementById("dts_adjust").value = parseInt(channel_values[response_index++]);
	document.getElementById("sdv_support").value = parseInt(channel_values[response_index++]);
	document.getElementById("starting_udp_port").value = parseInt(channel_values[response_index++]);
	document.getElementById("pat_interval").value = parseInt(channel_values[response_index++]);
	document.getElementById("pmt_interval").value = parseInt(channel_values[response_index++]);
	document.getElementById("nit_c_interval").value = parseInt(channel_values[response_index++]);
	document.getElementById("nit_o_interval").value = parseInt(channel_values[response_index++]);
	document.getElementById("sdt_c_interval").value = parseInt(channel_values[response_index++]);
	document.getElementById("sdt_o_interval").value = parseInt(channel_values[response_index++]);
	document.getElementById("bat_interval").value = parseInt(channel_values[response_index++]);
	document.getElementById("cat_interval").value = parseInt(channel_values[response_index++]);
}

// function to retrieve port parameters from the QAM
function GetChannelParameters()
{
	var xmlhttp = false;
	var Channel_Number;
	var response;
	var getParams = "type=8&cmd=1&channel=" + global_channel_index;

	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			response = xmlhttp.responseText.slice(7, -8);
			DisplayChannelParameters(response);
			GetDispAttr();
		}
	}
	xmlhttp.send(getParams);
}

// function to retrieve the current annex setting from the QAM
function GetAnnex()
{
	var xmlhttp = false;
	var getParams = "type=8&cmd=1&getAnnexMode=1";

	xmlhttp = getHTTPObject();
	// at this point we need to add the windmark for the frequency plan in addition
	//  to the annex type
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			g_annex_mode = parseInt(xmlhttp.responseText.slice(7, -8));
			AnnexDisplay(g_annex_mode);
			GetChannelParameters();
		}
	}
	xmlhttp.send(getParams);
}

function DealWithData(data)
{
	var len;
	var disp_attr;
	var rad_wrt;
	var table = document.getElementById("ch_config_table");
	
	for(var i = 0, len = data.length; i < len; i++)
	{
		if(i >= 11)
		{
			break;
		}
		disp_attr = (data[i] & DISP_ATTR_FLAG);
		rad_wrt = (data[i] & RAD_WRT_FLAG);
		
		if(disp_attr == DISP_ATTR_FLAG)//显示
		{
			table.children[0].children[i+2].style.display = "";
			
			if(rad_wrt == RAD_WRT_FLAG)//读写
			{
				document.getElementById(ctrlName[i]).disabled = false;
			}
			else //只读
			{
				document.getElementById(ctrlName[i]).disabled = true;
			}
		}
		else//隐藏
		{
			table.children[0].children[i+2].style.display = "none";
		}
	}
}

function GetDispAttr()
{
	var xmlhttp = false;
	var getParams = "type=8&cmd=1&getDispAttr=1";

	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText.slice(7, -8);
			var data = response.split("&");
			DealWithData(data);
		}
	}
	xmlhttp.send(getParams);
}

function GetIntervalID(num)
{
	var objId;
	switch(num)
	{
		case 0:
			objId = "pat_interval";
			break;
		case 1:
			objId = "pmt_interval";
			break;
		case 2:
			objId = "nit_c_interval";
			break;
		case 3:
			objId = "nit_o_interval";
			break;
		case 4:
			objId = "sdt_c_interval";
			break;
		case 5:
			objId = "sdt_o_interval";
			break;
		case 6:
			objId = "bat_interval";
			break;
		case 7:
			objId = "cat_interval";
			break;
		default:
			break;
	}
	return objId;
}

function ValidateChannelParam()
{
	var obj;
	if(symbol_rate_set)
	{
		obj = document.getElementById("symbol_rate");
		if(SymbolRateChange(obj) == false)
		{
			return false;
		}
	}
	if(transport_id_set)
	{
		obj = document.getElementById("transport_id");
		if(TansportIdChange(obj) == false)
		{
			return false;
		}
	}
	if(group_name_set)
	{
		obj = document.getElementById("qam_group_name");
		if(GroupNameChange(obj) == false)
		{
			return false;
		}
	}
	if(atten_set)
	{
		obj = document.getElementById("atten");
		if(AttenChange(obj) == false)
		{
			return false;
		}
	}
	if(starting_udp_set)
	{
		obj = document.getElementById("starting_udp_port");
		if(validateStartUdp(obj) == false)
		{
			return false;
		}
	}
	for(var i = 0; i < 8; i++)
	{
		var objId = GetIntervalID(i);
		if(interval_set[i])
		{
			obj = document.getElementById(objId);
			if(IntervalChange(obj, i) == false)
			{
				return false;
			}
		}
	}
}

/* function to set the port parameters */
function GenerateChannelParameter()
{
	var Params = "type=8&cmd=2&userName=" + userName + "&channel=" + global_channel_index + "&";
	var Portupdate = "112233";
	// use the set arrays to tell if something needs to be saved
	// there is no need to check annex type or anything since that is already
	//  handled based on the page display
	if(modulation_set == 1)
	{
		var modulation = document.getElementById("modulation").value;
		Params = Params + "modulation=" + modulation + "&";
	}
	if(symbol_rate_set == 1)
	{
		var symbol_rate = document.getElementById("symbol_rate").value;
		Params = Params + "symbol_rate=" + symbol_rate + "&";
	}
	if(bw_set == 1)
	{
		var bandwidth = document.getElementById("bandwidth").value;
		Params = Params + "bandwidth=" + bandwidth + "&";
	}
	if(interleaving_set == 1)
	{
		var interleaving = document.getElementById("interleaving").value;
		Params = Params + "interleaving=" + interleaving + "&";
	}
	if(mode_set == 1)
	{
		var channel_mode  = document.getElementById("channel_mode").value;
		Params = Params + "channel_mode=" + channel_mode + "&";
	}
	if(transport_id_set == 1)
	{
		var transport_id = document.getElementById("transport_id").value
		Params = Params + "transport_id=" + transport_id + "&";
	}
	if(manager_set == 1)
	{
		var qam_manager = document.getElementById("qam_manager").value;
		Params = Params + "qam_manager=" + qam_manager + "&";
	}
	if(group_name_set == 1)
	{
		var group_name = document.getElementById("qam_group_name").value;
		Params = Params + "qam_group_name=" + group_name + "&";
	}
	if(atten_set == 1)
	{
		var atten = document.getElementById("atten").value;
		Params = Params + "atten=" + atten + "&";
	}
	if(dts_adjust_set == 1)
	{
		var dts_adjust = document.getElementById("dts_adjust").value;
		Params = Params + "dts_adjust=" + dts_adjust + "&";
	}
	if(sdv_support_set == 1)
	{
		var sdv_support = document.getElementById("sdv_support").value;
		Params = Params + "sdv_support=" + sdv_support + "&";
	}
	if(starting_udp_set == 1)
	{
		var starting_udp_port = document.getElementById("starting_udp_port").value;
		Params = Params + "starting_udp_port=" + starting_udp_port + "&";
	}
	for(var i = 0; i < 8; i++)
	{
		if(interval_set[i] == 1)
		{
			var objId = GetIntervalID(i);
			var interval = document.getElementById(objId).value;
			Params = Params + objId + "=" + interval + "&" ;
		}
	}
	Params = Params + "Update=" + Portupdate ;
	return Params;
}

function ChannelSetValue()
{
  /* depending on the node value post the data*/
 	var xmlhttp = false;
	var params;

	/* Generate params to POST from the from controls */
	params = GenerateChannelParameter();

 	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);

	xmlhttp.onreadystatechange = function()
	{
   		if(xmlhttp.readyState == 4)
   		{
			if(language == 0)
			{
				alert("Channel cnfiguration modified successfully.");
			}
			else
			{
				alert("频点参数设置成功。");
			}
			PageLoadHandler();
   		}
	}

	xmlhttp.send(params);
}
/*Post the values */
function QamChannelApply()
{
	if(ValidateChannelParam() == false)
	{
		return false;
	}

	disabledButton(document.getElementById("Reset"), true);
	disabledButton(document.getElementById("Apply"), true);
	document.body.style.cursor="wait";
	window.status = "Applying changes, please wait...";
	ChannelSetValue();
}

function ResetColors()
{
	document.getElementById("modulation").style.backgroundColor = "white";
	document.getElementById("symbol_rate").style.backgroundColor = "white";
	document.getElementById("bandwidth").style.backgroundColor = "white";
	document.getElementById("interleaving").style.backgroundColor = "white";
	document.getElementById("channel_mode").style.backgroundColor = "white";
	document.getElementById("transport_id").style.backgroundColor = "white";
	document.getElementById("qam_manager").style.backgroundColor = "white";
	document.getElementById("qam_group_name").style.backgroundColor = "white";
	document.getElementById("atten").style.backgroundColor = "white";
	document.getElementById("dts_adjust").style.backgroundColor = "white";
	document.getElementById("sdv_support").style.backgroundColor = "white";
	document.getElementById("starting_udp_port").style.backgroundColor = "white";
	document.getElementById("pat_interval").style.backgroundColor = "white";
	document.getElementById("pmt_interval").style.backgroundColor = "white";
	document.getElementById("nit_c_interval").style.backgroundColor = "white";
	document.getElementById("nit_o_interval").style.backgroundColor = "white";
	document.getElementById("sdt_c_interval").style.backgroundColor = "white";
	document.getElementById("sdt_o_interval").style.backgroundColor = "white";
	document.getElementById("bat_interval").style.backgroundColor = "white";
	document.getElementById("cat_interval").style.backgroundColor = "white";
}

function ResetSetArrays()
{
	modulation_set = 0;
	symbol_rate_set = 0;
	bw_set = 0;
	interleaving_set = 0;
	mode_set = 0;
	transport_id_set = 0;
	manager_set = 0;
	group_name_set = 0;
	atten_set = 0;
	dts_adjust_set = 0;
	sdv_support_set = 0;
	starting_udp_set = 0;
	
	for(var i = 0; i < 8; i++)
	{
		interval_set[i] = 0;
	}
}

function PageLoadHandler()
{
	PageLoadFlag = 1;

	// disable the reset & apply buttons since this is fresh data
	disabledButton(document.getElementById("Reset"), true);
	disabledButton(document.getElementById("Apply"), true);

	window.status = "Retrieving data, please wait....";
	queryDeviceType();
	GetAnnex();
	ResetSetArrays();
	ResetColors();
	PageLoadFlag = 0;
	window.status = "Done";
	document.body.style.cursor="auto";
	EnableReset();
}

//查询当前设备类型
function queryDeviceType()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=54&cmd=1&ran=" + Math.random();

	xmlhttp.open("GET", "/goform/formIPQAM?" + getParams, true);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var deviceType = xmlhttp.responseText.slice(7, -8);
			if(deviceType == TYPE_518B)
			{
				$("#psiInterval").hide();				
				var optionStrC = '<option value="0">8VSB</option>';
				optionStrC  += '<option value="1">16VSB</option>';				
			}
			else
			{
				var optionStrC = '<option value="0">QAM 64</option>';
				optionStrC  += '<option value="1">QAM 128</option>';
				optionStrC  += '<option value="2">QAM 256</option>';
				$("#psiInterval").show();
			}
			$("#modulation").empty();
			$("#modulation").append(optionStrC);
		}
	}
	xmlhttp.send(null);
	return true;
}
/* function to reload the values */
function QamChannelReload()
{
	document.body.style.cursor="wait";
	PageLoadHandler();
}

window.onload = function()
{
	var nodeId;

	document.body.style.cursor="wait";

	var args = getArgs();
	var nodeId = args["nodeId"];
	var group = args["group"];
	userName = args["userName"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	port_index = parseInt(str[2]);
	channel_index = parseInt(str[3]);
	
	global_channel_index = card_index + "/" + port_index + "." + channel_index;
	// now set the RF port value in the table
	document.getElementById("channel").innerHTML = global_channel_index;
	language = document.getElementById("language").value;
	var apply = document.getElementById("Apply");
	applyDispay(group, apply);
	PageLoadHandler();
}


function EnableApply()
{
	if(!PageLoadFlag)
	{
		disabledButton(document.getElementById("Apply"), false);
	}
}

function EnableReset()
{
	disabledButton(document.getElementById("Reset"), false);
}

function setAllInterval()
{
	var i;
	var objId;
	var obj;
	for(i = 0; i < 8; i++)
	{
		objId = GetIntervalID(i);
		obj = document.getElementById(objId);
		SetColor(obj,"Yellow");
		interval_set[i] = 1;
	}
	EnableApply();
}

var confirmResult = false;
function goClear()
{
	if(language == 0)
	{
		if(confirm("Are you sure to clear all the intervals?"))
		{
			confirmResult = true;
		}
		else
		{
			confirmResult = false;
		}
	}
	else
	{
		if(confirm("确定表间隔全部清零？"))
		{
			confirmResult = true;
		}
		else
		{
			confirmResult = false;
		}
	}
	if(confirmResult)
	{
		document.getElementById("pat_interval").value = 0;
		document.getElementById("pmt_interval").value = 0;
		document.getElementById("nit_c_interval").value = 0;
		document.getElementById("nit_o_interval").value = 0;
		document.getElementById("sdt_c_interval").value = 0;
		document.getElementById("sdt_o_interval").value = 0;
		document.getElementById("bat_interval").value = 0;
		document.getElementById("cat_interval").value = 0;
		
		setAllInterval();
	}
	else
	{
		PageLoadHandler();
	}
}

function goDefault()
{
	if(language == 0)
	{
		if(confirm("Are you sure to restore the default value?"))
		{
			confirmResult = true;
		}
		else
		{
			confirmResult = false;
		}
	}
	else
	{
		if(confirm("确定表间隔全部恢复默认值？"))
		{
			confirmResult = true;
		}
		else
		{
			confirmResult = false;
		}
	}
	if(confirmResult)
	{
		document.getElementById("pat_interval").value = 100;
		document.getElementById("pmt_interval").value = 100;
		document.getElementById("nit_c_interval").value = 1000;
		document.getElementById("nit_o_interval").value = 1000;
		document.getElementById("sdt_c_interval").value = 300;
		document.getElementById("sdt_o_interval").value = 300;
		document.getElementById("bat_interval").value = 1000;
		document.getElementById("cat_interval").value = 300;

		setAllInterval();
	}
	else
	{
		PageLoadHandler();
	}
}
